<?php
/***************************************************************************
 *                  spider_friendly_cache.php
 *                  -------------------
 *   begin        : Monday, June 13, 2005
 *   copyright    : (C) 2005 Crack
 *   email        : piotrac@poczta.onet.pl
 *
 ***************************************************************************/

set_time_limit(120);

function message_die($type, $error, $title, $line, $file, $sql = '')
{
	global $db;

	$file = basename($file);
	if ($sql)
	{
		$err = $db->sql_error();
		$sql_append = '<hr style="border:0; border-top:1px #FFB144 solid" />'
			. '<b>' . $err['code'] . '</b>: ' . $err['message'] . '<pre>' . $sql . '</pre>';
	}
	else
	{
		$sql_append = '';
	}
	echo '<div ><b>Error</b> in ' . $file . ' (' . $line . ')<div style="border:1px red solid; background:#FFE9CA; padding:1em">';
	echo $error . $sql_append;
	echo '</div></div>';
	$db->sql_close();
	exit;
}

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'config.'.$phpEx);
include($phpbb_root_path . 'includes/constants.'.$phpEx);
include($phpbb_root_path . 'includes/db.'.$phpEx);

$board_config = array();
$sql = "SELECT *
	FROM " . CONFIG_TABLE;
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query config', '', __LINE__, __FILE__, $sql);
}
while ($row = $db->sql_fetchrow($result))
{
	$board_config[$row['config_name']] = $row['config_value'];
}

define('SF_SKIP_CACHE_UPDATE', true);
include($phpbb_root_path . 'includes/spider_friendly.'.$phpEx);

$cache = $sfc['post_topic_fcache'];
// cron || limit: 30 secs limit OK. || request from server, can be also cron
if (!isset($_SERVER['REQUEST_METHOD']) || filemtime($cache) < (time()-30) || $_SERVER['REMOTE_ADDR'] == $_SERVER['SERVER_ADDR'])
{
	build_post_topic_cache('force');
}
// no cron and accepts HTTP output
else if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REMOTE_ADDR'] != $_SERVER['SERVER_ADDR'])
{
	message_die(GENERAL_ERROR, 'You must wait at least 30 seconds before refreshing cache.<br />It was last refreshed: ' . date('Y-m-d H:i:s', filemtime($cache)) . '<br />Now it is: ' . date('Y-m-d H:i:s'), '', __LINE__, __FILE__);
}
?>
