<?php
/***************************************************************************
 *                  admin_spider_friendly.php
 *                  -------------------
 *   begin        : Monday, Apr 11, 2005
 *   copyright    : (C) 2005 Crack
 *   email        : piotrac@poczta.onet.pl
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if ( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['AASpider_Friendly'][$lang['Configuration']] = "$file?mode=config";
	$module['AASpider_Friendly'][$lang['Search_Engines']] = "$file?mode=viewspiders";
	$module['AASpider_Friendly'][$lang['Sitemap_Preview']] = "$file?mode=sitemap_preview";
	$module['AASpider_Friendly'][$lang['Forum_Preview']] = "$file?mode=forum_preview";

	return;
}

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_admin_sf.' . $phpEx);

$mode = isset($_GET['mode']) ? $_GET['mode'] : 'config';
if( !in_array($mode, array('config', 'viewspiders', 'sitemap_preview', 'forum_preview')) ) $mode = 'config';

$checked = ' checked="checked"';
$selected = ' selected="selected"';
$defaults = array(
	'mod_rewrite_enabled' => true,
	'spiders_only' => false,
	'rewrite_all_htm' => true,
	'rewrite_index' => true,
	'rewrite_mode' => 1,
	'charset_mapping' => 'auto',
	'fake_dirs' => true,
	'postlink_rewrite' => true,
	'max_keywords_length' => 768,
	'sitemap_enabled' => true,
	'show_lastpost_link' => false,
	'map_spiders_only' => true,
	'map_index_only' => true,
	'topics_per_page' => 30,
	'log_spiders' => true,
	'spider_session_length' => 900,
	'cache_refresh_mode' => '10min',
	'cache_read_mode' => 'memory'
);

function field_validate($field_name, $value)
{
	global $phpbb_root_path, $phpEx;
	switch ($field_name)
	{
		case 'charset_mapping':
			return ($value == 'auto' || file_exists($phpbb_root_path . "includes/map.$value.$phpEx"));
			break;
		case 'cache_read_mode':
			return ($value == 'file-direct' || $value == 'memory');
			break;
		case 'cache_refresh_mode':
			return ($value == '10min' || $value == 'post' || $value == 'manual');			
			break;
	}
	return false;
}

if( $mode == 'config' )
{
	function get_checkbox_selname($cfg_var, $testval = null, $only_values_given = false)
	{
		global $sfc, $defaults;

		if( is_null($testval) ) $testval = array(true => 'YES', false => 'NO');
		else if( $only_values_given )
		{
			for( $i = 0; $i < count($testval); $i++ )
			{
				$testval[$testval[$i]] = $testval[$i];
				unset($testval[$i]);
			}
		}
		$var = strtoupper($cfg_var) . '_';

		foreach( $testval as $test => $return_value )
		{
			if( $sfc[$cfg_var] == $test ) return $var . strtoupper($return_value);
		}
		return $var . strtoupper($testval[$defaults[$cfg_var]]);
	}

	function microtime_float()
	{
		list($usec, $sec) = explode(' ', microtime());
		return ((float)$usec + (float)$sec);
	}

	if( isset($_POST['submit']) )
	{
		$names = array_keys($defaults);
		foreach( $names as $opt_name )
		{
			if( !isset($_POST[$opt_name]) ) continue;
			if( is_int($defaults[$opt_name]) )
			{
				$opt_value = intval($_POST[$opt_name]);
			}
			elseif( is_bool($defaults[$opt_name]) )
			{
				$opt_value = intval($_POST[$opt_name]);
				if( $opt_value != 0 && $opt_value != 1 ) $opt_value = $defaults[$opt_name];
			}
			else
			{
				$opt_value = str_replace("\'", "''", $_POST[$opt_name]);
				if( !field_validate($opt_name, $opt_value) ) $opt_value = $defaults[$opt_name];
			}
			$sql = 'UPDATE ' . CONFIG_TABLE  . "
				SET config_value = '$opt_value'
				WHERE config_name = 'sf_$opt_name'";
			if (!$db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, 'Failed to save new settings for ' . $opt_name, '', __LINE__, __FILE__, $sql);
			}
		}
		if( isset($_POST['postlink_rewrite']) && $_POST['postlink_rewrite'] && !$sfc['postlink_rewrite'] )
		{
			build_post_topic_cache('full_force');
		}
		$message = $lang['SF_Saved_Settings'] . '<br /><br />' . sprintf($lang['Click_Return_SF'], '<a href="' . append_sid("admin_spider_friendly.$phpEx?mode=config") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	if( isset($_POST['restore']) )
	{
		foreach( $defaults as $def_name => $def_value )
		{
			$sql = 'UPDATE ' . CONFIG_TABLE . "
				SET config_value = '$def_value'
				WHERE config_name = 'sf_$def_name'";
			if (!$db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, "Failed to restore mod\'s default settings ($def_name)", '', __LINE__, __FILE__, $sql);
			}
		}
		$message = $lang['SF_Restored_Settings'] . '<br /><br />' . sprintf($lang['Click_Return_SF'], '<a href="' . append_sid("admin_spider_friendly.$phpEx?mode=config") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	$template->set_filenames(array(
		'body' => 'admin/sf_config.tpl')
	);

	//
	// Zbuduj list mapowania i znajd kodowanie forum
	//
	$dir = @opendir($phpbb_root_path . 'includes/');
	while( ($filename = @readdir($dir)) !== false )
	{
		if ( preg_match('/map\..+\.' . preg_quote($phpEx) . '/', $filename) )
		{
			$maps[] = substr($filename, 4, -4);
		}
	}
	@closedir($dir);
	sort($maps);
	if( isset($lang['ENCODING']) && $lang['ENCODING'] )
	{
		$mapping = strtolower($lang['ENCODING']);
	}
	if( !$mapping || !file_exists($phpbb_root_path . 'includes/map.' . $mapping . ".$phpEx") )
	{
		$mapping = 'iso-8859-2';
	}
	$cm_set = $sfc['charset_mapping'];
	$cm_select = '<select name="charset_mapping">';
	$cm_select .= '<option value="auto"' . ($cm_set == 'auto' ? $selected : '') . '>' . sprintf($lang['SF_Charset_Mapping_Auto'], $mapping) . '</option>';
	for($i = 0; $i < count($maps); $i++)
	{
		$cm_select .= '<option value="' . $maps[$i] . '"' . ($cm_set == $maps[$i] ? $selected : '') . '>' . $maps[$i] . '</option>';
	}
	$cm_select .= '</select>';

	//
	// Test szybkoci cache
	//
	if( isset($_GET['benchmark']) && $_GET['benchmark'] == 1 )
	{
		list($usec, $sec) = explode(" ", microtime());
		$start = microtime_float();
		build_post_topic_cache('force');
		$t1 = round(microtime_float() - $start, 5);

		if( $sfc['post_topic'] ) $sfc['post_topic'] = '';
		if( isset($sfc['cache_fp']) )
		{
			fclose($sfc['cache_fp']);
			unset($sfc['cache_fp']);
		}
		$read_mode = $sfc['cache_read_mode'];
		$max_post = filesize($sfc['post_topic_fcache']) / 6;

		$sfc['cache_read_mode'] = 'file-direct';
		$start = microtime_float();
		for( $i = 0; $i < 100; $i++ )
		{
			$post_data = get_post2topic_mapping(mt_rand(1, $max_post));
		}
		$t2 = round(microtime_float() - $start, 5);

		$sfc['cache_read_mode'] = 'memory';
		$start = microtime_float();
		for( $i = 0; $i < 100; $i++ )
		{
			$post_data = get_post2topic_mapping(mt_rand(1, $max_post));
		}
		$t3 = round(microtime_float() - $start, 5);
		$sfc['cache_read_mode'] = $read_mode;
		if( $sfc['cache_read_mode'] == 'memory' )
		{
			fclose($sfc['cache_fp']);
			unset($sfc['cache_fp']);
		}
		else $sfc['post_topic'] = '';
		$template->assign_block_vars('cache_benchmark', array(
			'CACHE_BENCH_RESULTS' => sprintf($lang['SF_Cache_Bench_Results'], $t1, $t2, $t3))
		);
	}
	//
	// Szablon: wczytaj wartoci pl boolowskich
	//
	$tpl_vars = array();
	foreach( $defaults as $def_name => $def_value )
	{
		if( is_bool($def_value) )
		{
			$tpl_vars += array(get_checkbox_selname($def_name) => $checked);
		}
	}

	//
	// Szablon: wczytaj opisy pl
	//
	$lang_names = array('Rewrite_Enabled', 'Spiders_Only', 'Rewrite_Mode',
		'Charset_Mapping', 'Fake_Dirs', 'Max_KW_Length', 'Mod_Enabled',
		'Show_Lastpost_Link', 'Map_Spiders_Only', 'Map_Index_Only',
		'Topics_Per_Page', 'Spider_Session_Length', 'Cache_Refresh_Mode',
		'Update_On_Post', 'Update_10_Minutes', 'Update_Manual',
		'Rewrite_All_HTM', 'Rewrite_Index', 'Cache_Read_Mode',
		'Cache_File_Direct', 'Cache_Memory', 'Cache_Benchmark', 'Rwm_Simple',
		'Rwm_Keyworded');
	foreach( $lang_names as $lang_name )
	{
		$tpl_vars += array('L_' . strtoupper($lang_name) => $lang['SF_'.$lang_name]);
		if( isset($lang['SF_'.$lang_name.'_E']) )
		{
			$tpl_vars += array('L_' . strtoupper($lang_name) . '_E' => $lang['SF_'.$lang_name.'_E']);
		}
	}

	$template->assign_vars($tpl_vars);
	$template->assign_vars(array(
		'S_ACTION' => append_sid("admin_spider_friendly.$phpEx?mode=config"),
		'U_BENCHMARK' => append_sid("admin_spider_friendly.$phpEx?mode=config&amp;benchmark=1"),

		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],

		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'L_RESTORE_DEFAULTS' => $lang['Restore_Defaults'],

		'L_POSTLINK_REWRITE' => $lang['SF_Postlink_Rewrite'],
		'L_POSTLINK_REWRITE_E' => sprintf($lang['SF_Postlink_Rewrite_E'], $phpEx, $phpEx, $phpEx),//Bool

		get_checkbox_selname('rewrite_mode', array(1 => 'simple', 2 => 'kwd'), false) => $checked,
		get_checkbox_selname('cache_read_mode', array('file-direct', 'memory'), true) => $checked,
		get_checkbox_selname('cache_refresh_mode', array('10min', 'post', 'manual'), true) => $checked,
		'CHARSET_MAPPING_SELECT' => $cm_select,
		'MAX_KEYWORDS_LENGTH_VALUE' => $sfc['max_keywords_length'],
		'TOPICS_PER_PAGE_VALUE' => $sfc['topics_per_page'],
		'SPIDER_SESSION_LENGTH_VALUE' => $sfc['spider_session_length'],

		'L_TITLE' => $lang['SF_Config_Title'],
		'L_EXPLAIN' => $lang['SF_Config_Title_E'],
		'L_TITLE_REWRITE' => $lang['SF_Title_Rewrite'],
		'L_TITLE_SITEMAP' => $lang['SF_Title_Sitemap'],
		'L_TITLE_LOG_SPIDERS' => $lang['SF_Title_Log_Spiders'] )
	);

	$template->pparse('body');
}
elseif( $mode == 'sitemap_preview' )
{
	$redirect_url = append_sid("sitemap.$phpEx");
}
elseif( $mode == 'forum_preview' )
{
	$redirect_url = "index.$phpEx?forcespider=1";
}
elseif( $mode == 'viewspiders' )
{
	if( isset($_POST['clear_forced']) || isset($_POST['clear_all']) )
	{
		$cforced = isset($_POST['clear_forced']);
		$sql = 'DELETE FROM ' . SPIDER_LOG_TABLE
			. ($cforced ? " WHERE spider_name LIKE 'Forced: %'" : '');
		if (!$db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, 'Failed to delete log information from table', '', __LINE__, __FILE__, $sql);
		}
		$message = ($cforced ? $lang['Spiders_Cleared_Forced'] : $lang['Spiders_Cleared_All']) . '<br /><br />' . sprintf($lang['Click_Return_Spiders'], '<a href="' . append_sid("admin_spider_friendly.$phpEx?mode=viewspiders") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');
		message_die(GENERAL_MESSAGE, $message);
	}

	$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
	if( $start < 0 ) $start = 0;
	if( $start % $board_config['posts_per_page'] != 0 ) $start = floor($start / $board_config['posts_per_page']) * $board_config['posts_per_page'];

	$template->set_filenames(array(
		'body' => 'admin/sf_spider_log.tpl')
	);

	$sql = 'SELECT COUNT(*) AS count FROM ' . SPIDER_LOG_TABLE;
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain spiders information', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$total = $row['count'];
	$pagination = generate_pagination(append_sid("admin_spider_friendly.$phpEx?mode=viewspiders"), $total, $board_config['posts_per_page'], $start);
	$db->sql_freeresult($result);

	if ($total > 0)
	{
		$sql = 'SELECT * FROM ' . SPIDER_LOG_TABLE . "
			ORDER BY spider_lastvisit DESC
			LIMIT $start, {$board_config['posts_per_page']}";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain spiders information', '', __LINE__, __FILE__, $sql);
		}

		$curr_id = $total - $start;
		while( $row = $db->sql_fetchrow($result) )
		{
			$active_time = $row['spider_lastvisit'] - $row['spider_firstvisit'];
			$active_time = ( $active_time > 60 )
				? sprintf($lang['time']['minutes'], floor($active_time / 60), ($active_time % 60))
				: sprintf($lang['time']['seconds'], $active_time);
			$template->assign_block_vars('spider', array(
				'ID' => $curr_id,
				'NAME' => $row['spider_name'],
				'FIRSTTIME' => sprintf(create_date($board_config['default_dateformat'], $row['spider_firstvisit'], $board_config['board_timezone'])),
				'ACTIVE_TIME' => $active_time,
				'PAGES' => $row['spider_hits'] )
			);
			$curr_id--;
		}

		$template->assign_block_vars('page', array(
			'PAGINATION' => $pagination,
			'PAGE_NUMBER' => sprintf($lang['Page_of'], (floor($start / $board_config['posts_per_page']) + 1), ceil($total / $board_config['posts_per_page'])) )
		);
	}
	else
	{
		$template->assign_block_vars('nospiders', array());
	}

	$template->assign_vars(array(
		'S_ACTION' => append_sid("admin_spider_friendly.$phpEx?mode=viewspiders"),

		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],

		'L_CLEAR' => $lang['Spider_Clear'],
		'L_CLEAR_FORCED' => $lang['Spider_Clear_Forced'],
		'L_SPIDER_TITLE' => $lang['Spiders_Title'],
		'L_SPIDER_EXPLAIN' => $lang['Spiders_Explain'],
		'L_SPIDER_ID' => $lang['Spider_ID'],
		'L_SPIDER_NAME' => $lang['Spider_Name'],
		'L_SPIDER_TIME' => $lang['Spider_Time'],
		'L_SPIDER_PAGES' => $lang['Spider_Pages'],
		'L_EXPLAIN' => $lang['Spider_No_Bot'] )
	);

	$template->pparse('body');
}

if( isset($redirect_url) )
{
	if( !headers_sent() )
	{
		redirect($redirect_url);
	}
	else
	{
		@ob_end_clean();
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $redirect_url . '"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $redirect_url . '">HERE</a> to be redirected</div></body></html>';
		exit;
	}
}
include('./page_footer_admin.'.$phpEx);

?>