<?php
/***************************************************************************
 *                  sitemap.php
 *                  -------------------
 *   begin        : Thursday, March 10, 2005
 *   copyright    : (C) 2005 Crack
 *   email        : piotrac@poczta.onet.pl
 *
 *   Based on spyder_manage.php from Spyder Manage mod
 *   by netclectic - Adrian Cockburn - adrian@netclectic.com
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);

if( isset($_GET['offset']) )
{
	$offset = ($_GET['offset'] >= 0) ? intval($_GET['offset']) : 0;
}
else
{
	$offset = 0;
}

if( $offset % $sfc['topics_per_page'] != 0 )
{
	$offset = floor($offset / $sfc['topics_per_page']) * $sfc['topics_per_page'];
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: ' . mod_rewrite_replace("sitemap.$phpEx?offset=" . $offset, true));
}

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

$page_title = 'Site map';
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

function is_jra($user_id)
{
	if( !function_exists('is_jr_admin') ) return false;
	return function_exists('is_jr_admin_buffered')
		? is_jr_admin_buffered($user_id)
		: is_jr_admin($user_id);
}

$sql_add = ( strpos(strtolower($board_config['version']), 'przemo') )
	? "
		AND f.password = ''
		AND (f.forum_link = '' OR forum_link IS NULL)"
	: '';
$sql = "SELECT COUNT(*) as total_topics
	FROM " . TOPICS_TABLE . " t, ". FORUMS_TABLE . " f, " . POSTS_TABLE . " p
	WHERE f.forum_id = t.forum_id
		AND f.auth_view = 0
		AND f.auth_read = 0 $sql_add
		AND p.post_id = t.topic_first_post_id";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query topic count info', '', __LINE__, __FILE__, $sql);
}
$row = $db->sql_fetchrow($result);
$total_topics = $row['total_topics'];

$sql = "SELECT c.cat_id, c.cat_title, f.forum_id, f.forum_name, f.forum_desc, f.auth_view, t.topic_id, t.topic_title, t.topic_last_post_id, t.topic_replies, p.poster_id, p.enable_html, p.enable_smilies, pt.bbcode_uid, pt.post_text 
	FROM " . FORUMS_TABLE . " f, " . TOPICS_TABLE . " t, " . POSTS_TEXT_TABLE . " pt, " . POSTS_TABLE . " p
		LEFT JOIN " . CATEGORIES_TABLE . " c ON c.cat_id = f.cat_id
	WHERE f.forum_id = t.forum_id
		AND f.auth_view = 0
		AND f.auth_read = 0 $sql_add
		AND p.post_id = t.topic_first_post_id
		AND pt.post_id = t.topic_first_post_id
	ORDER BY c.cat_order, f.forum_order, t.topic_last_post_id DESC 
	LIMIT $offset, {$sfc['topics_per_page']}";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query topic info', '', __LINE__, __FILE__, $sql);
}

$template->set_filenames(array(
	'body' => 'sitemap.tpl')
);

$user_id = &$userdata['user_id'];
$user_level =& $userdata['user_level'];
$null_group_exists = false;
$cat_group_exists = false;
$numrows = $db->sql_numrows();
$i = 1;
while( $topicrow = $db->sql_fetchrow($result) )
{
	$forum_id =& $topicrow['forum_id'];
	if( isset($tree) )
	{
		$is_auth =& $tree['auth'][POST_FORUM_URL . $forum_id];
	}
	else
	{
		$is_auth['auth_mod'] = false;
	}

	$cat_null = is_null($topicrow['cat_id']);
	if( $cat_null )
	{
		if( !$null_group_exists )
		{
			$template->assign_block_vars('forumlist', array());
			$template->assign_block_vars('forumlist.cat_null_title', array());
			$null_group_exists = true;
		}
		$cat_url = '';
		$cat_title = '';
	}
	else
	{
		if( !$cat_group_exists )
		{
			$template->assign_block_vars('forumlist', array());
			$template->assign_block_vars('forumlist.cat_title', array());
			$cat_group_exists = true;
		}
		$cat_url = mod_rewrite_replace("index.$phpEx?" . POST_CAT_URL . '=' . $topicrow['cat_id']);
		$cat_title = $topicrow['cat_title'];
	}

	$bbcode_uid = $topicrow['bbcode_uid'];
	$forum_url = mod_rewrite_replace("viewforum.$phpEx?" . POST_FORUM_URL . '=' . $forum_id);
	$forum_name = $topicrow['forum_name'];

	$topic_url = mod_rewrite_replace("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $topicrow['topic_id']);
	$topic_title = $topicrow['topic_title'];

	$last_post = mod_rewrite_replace("viewtopic.$phpEx?" . POST_POST_URL . '=' . $topicrow['topic_last_post_id'] . '#' . $topicrow['topic_last_post_id']);
	$topic_replies = $topicrow['topic_replies'];

	$poster_id = $topicrow['poster_id'];
	$post_url = '';

	$poster_is_jr_admin = is_jra($poster_id);
	$poster_is_mod_here = $is_auth['auth_mod'];

    $message =& $topicrow['post_text'];

	if ( !$board_config['allow_html'] && (!( ($poster_is_mod_here && $board_config['mod_html']) || ($board_config['admin_html'] && $poster_level == ADMIN) || ($board_config['jr_admin_html'] && $poster_is_jr_admin) )) )
	{
		if ( $postrow[$i]['enable_html'] )
		{
			$message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
		}
	}

    $post_text_html = (strpos('<td>', $message) !== false || strpos('<tr>', $message) != false || strpos('<table>', $message) !== false) ? true : false;

	if ( $user_level == ADMIN || $poster_is_jr_admin || $is_auth['auth_mod'] )
	{
		$message = preg_replace("#\[mod\](.*?)\[/mod\]#si", "<br><u><b>Mod Info:</u><br>[</b>\\1<b>]</b><br>", $message);
	}
	elseif ( strpos('[mod]', $message) !== false )
	{
		$message = preg_replace('#\[mod\](.*?)\[/mod\]#si', '', $message);
  		$message = bbencode_first_pass($message, $bbcode_uid);
	}

	if ( $bbcode_uid != '' )
	{
		$message = bbencode_second_pass($message, $bbcode_uid, $userdata['username']);
		if( function_exists('bbencode_third_pass') ) $message = bbencode_third_pass($message, $bbcode_uid, false);
	}

	$message = make_clickable($message);

	if ( $board_config['allow_smilies'] && $topicrow[$i]['enable_smilies'] )
	{
		$message = smilies_pass($message);
	}

	if ( !(($postrow[$i]['enable_html'] && $post_text_html && (($poster_is_mod_here && $board_config['mod_html']) || ($board_config['admin_html'] && $poster_level == ADMIN) || ($board_config['jr_admin_html'] && $poster_is_jr_admin)))) )
	{
		$message = str_replace("\n", "\n<br />\n", $message);
	}

	$template->assign_block_vars('forumlist.topic_row', array(
		'CAT_URL' => $cat_url,
		'CAT_TILE' => $cat_title,
		'FORUM_URL' => $forum_url,
		'FORUM_NAME' => $forum_name,
		'TOPIC_URL' => $topic_url,
		'TOPIC_TITLE' => $topic_title,
		'TOPIC_REPLIES' => $topic_replies,
		'LAST_POST' => $last_post,
		'POST_TEXT' => $message
		)
	);

	if( !$cat_null ) $template->assign_block_vars('forumlist.topic_row.cat_title', array());
	if( $topic_replies > 0 && $sfc['show_lastpost_link'] ) $template->assign_block_vars('forumlist.topic_row.lastpost_link', array());
	if( $i == $numrows ) $template->assign_block_vars('forumlist.pagination_row', array());
	else $i++;
}

$prev_url = $next_url = '';
if( $offset > 0 )
{
	$prev_offset = ($offset - $sfc['topics_per_page'] > 0)
		? $offset - $sfc['topics_per_page']
		: 0;
	$prev_url = mod_rewrite_replace("sitemap.$phpEx?offset=" . $prev_offset);
	$template->assign_block_vars('switch_prev', array());
}
$offset = $offset + $sfc['topics_per_page'];
if( ($total_topics - $offset) > 0 )
{
	$next_url = mod_rewrite_replace("sitemap.$phpEx?offset=" . $offset);
	$template->assign_block_vars('switch_next', array());
}

$total_pages = ceil($total_topics / $sfc['topics_per_page']);
$paginate = '';
$curr_page = $offset / $sfc['topics_per_page'];
$show_pages = array(1, 2, $curr_page-1, $curr_page, $curr_page+1, $total_pages-1, $total_pages);
$show_pages = array_unique($show_pages);
$last_shown = true;
for( $i = 1; $i <= $total_pages; $i++ )
{
	if( in_array($i, $show_pages) )
	{
		$page_offset = ($i-1)*$sfc['topics_per_page'];
		$paginate .= ($last_shown ? ($i>1?' - ':'') : ' ... ' )
			. ($i != $curr_page
				? '<a class="gen" href="' . mod_rewrite_replace("sitemap.$phpEx?offset=" . $page_offset) . '">' . $i . '</a>'
				: '<b>' . $i . '</b>');
		$last_shown = true;
	}
	else
	{
		$last_shown = false;
	}
}

$template->assign_vars( array(
	'L_CAT' => $lang['Category'],
	'L_FORUM' => $lang['Forum'],
	'L_TOPIC' => $lang['Topic'],
	'L_LASTPOST' => $lang['Last_Post'],
	'L_NEXT' => $lang['Next'],
	'L_PREVIOUS' => $lang['Previous'],
	'L_REPLIES' => $lang['Replies'],
	'NEXT_URL' => $next_url,
	'PAGINATION' => $paginate,
	'PREV_URL' => $prev_url )
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
?>